/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.tile.container;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.registry.ModContainerTypes;
import vectorwing.farmersdelight.tile.CookingPotTileEntity;
import vectorwing.farmersdelight.tile.container.CookingPotMealSlot;
import vectorwing.farmersdelight.tile.container.CookingPotResultSlot;

public class CookingPotContainer
extends Container {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BOWL = new ResourceLocation("farmersdelight", "item/empty_container_slot_bowl");
    public final CookingPotTileEntity tileEntity;
    public final ItemStackHandler inventoryHandler;
    private final IIntArray cookingPotData;
    private final IWorldPosCallable canInteractWithCallable;

    public CookingPotContainer(int windowId, PlayerInventory playerInventory, CookingPotTileEntity tileEntity, IIntArray cookingPotDataIn) {
        super((ContainerType)ModContainerTypes.COOKING_POT.get(), windowId);
        int column;
        this.tileEntity = tileEntity;
        this.inventoryHandler = tileEntity.getInventory();
        this.cookingPotData = cookingPotDataIn;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        int startX = 8;
        int startY = 18;
        int inputStartX = 30;
        int inputStartY = 17;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (column = 0; column < 3; ++column) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.inventoryHandler, row * 3 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.func_75146_a((Slot)new CookingPotMealSlot((IItemHandler)this.inventoryHandler, 6, 124, 26));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.inventoryHandler, 7, 92, 55){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_CONTAINER_SLOT_BOWL);
            }
        });
        this.func_75146_a((Slot)new CookingPotResultSlot((IItemHandler)this.inventoryHandler, 8, 124, 55));
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.func_75146_a(new Slot((IInventory)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot((IInventory)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.func_216961_a(cookingPotDataIn);
    }

    private static CookingPotTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof CookingPotTileEntity) {
            return (CookingPotTileEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public CookingPotContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, CookingPotContainer.getTileEntity(playerInventory, data), (IIntArray)new IntArray(4));
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return CookingPotContainer.func_216963_a((IWorldPosCallable)this.canInteractWithCallable, (PlayerEntity)playerIn, (Block)((Block)ModBlocks.COOKING_POT.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        int indexMealDisplay = 6;
        int indexContainerInput = 7;
        int indexOutput = 8;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == indexOutput) {
                if (!this.func_75135_a(itemstack1, startPlayerInv, endPlayerInv, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index > indexOutput) {
                if (itemstack1.func_77973_b() == Items.field_151054_z && !this.func_75135_a(itemstack1, indexContainerInput, indexContainerInput + 1, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(itemstack1, 0, indexMealDisplay, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(itemstack1, indexContainerInput, indexOutput, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(itemstack1, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        int i = this.cookingPotData.func_221476_a(0);
        int j = this.cookingPotData.func_221476_a(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isHeated() {
        return this.tileEntity.isAboveLitHeatSource();
    }
}

